#include <wx/string.h>

namespace llm
{
const wxString PROMPT_DOCSTRING_GEN = R"#(
Generate a docstring for the following {{lang}} function. The output should only include the docstring, nothing else.
The output should not include the input function.

Use comment style that is appropriate for the language:

If the input function is a C++, PHP or a Java function, use JavaDoc style comments.
If the input function is a Rust function, use Rust comment style (each line starts with `/// `).
If the input function is bash, use bash style comment ('# ').
If the input function is python, use python comment style.

The input function to write comment for is:

```{{lang}}
{{function}}
```

Example 1:
===

If the function is:

```c++
void Add(int a, int b) {
    return a + b;
}
```

The output should be something like this:

/**
 * @brief this function returns the sum of 2 numbers.
 *
 * @param a the first number
 * @param b the second number
 */

Example 2:
===

If the function is:

```rust
pub fn add(a: u32, b: u32) -> u32{
    a + b
}
```

The output should be something like this:

/// This function returns the sum of 2 numbers.
///
/// `a` the first number
/// `b` b the second number

Example 3:
===

If the function is:

```python
def add(a, b):
    return a + b
```

The output should be something like this:

"""
This function returns the sum of 2 numbers.

Args:
    a (int): the first number
    b (int): the second number

Returns:
    int: the sum of a + b.

Example:
    >>> add(1, 2)
    3
"""
)#";

const wxString PROMPT_GIT_COMMIT_MSG = R"#(Given the below git diff, generate a commit message.
Append a footer with the following text at the end of the generated commit message:
"** Generated by CodeLite. **"

The first line of the generated commit message, must be a summary sentence that describing the commit.

Use bullets.

The git diff is:

```diff
{{context}}
```
)#";

const wxString PROMPT_GIT_RELEASE_NOTES = R"(Generate release notes from the following list of git commits history.
Make sure to include a "bug fixes"' section. Include a "major improvements" section. Include a section that states
the contributors and the number of commits each contributor committed. Sort the contributors by number of commits.
Use bullets.

The list of git commits are:

```text
{{context}}
```
)";

const wxString PROMPT_GIT_RELEASE_NOTES_MERGE = R"(
Rephrase the following release notes text. Remove duplicate entries and merge the sections.

Add a summary section that contains list of contributors and the number of commit they did.

Here are the release notes:

```markdown
{{context}}
```
)";

const wxString PROMPT_GIT_CODE_REVIEW =
    R"(You are an expert developer performing a code review. Your task is to analyze the provided git diff and offer constructive feedback.

Your review should cover the following points:
1.  **Code quality and best practices:** Are standard patterns followed? Is the code readable? Is it adhering to the DRY (Don't Repeat Yourself) principle?
2.  **Potential bugs and logical errors:** Identify any obvious issues or edge cases that might cause problems.
3.  **Performance implications:** Flag any changes that might negatively impact performance.
4.  **Security vulnerabilities:** Point out any security risks introduced by the changes.
5.  **Maintainability:** Are the changes easy to understand and maintain over time?

Provide a concise summary at the beginning of your review. For each suggestion, use a GCC style format.
If you provide a code example for an improvement, include the filename where the change should be applied.

Here is the git diff to review:

```diff
{{context}}
```

Here are some examples:

## Example:

Example input git diff:

```diff
diff --git a/Plugin/CustomControls/TextGenerationPreviewFrame.cpp b/Plugin/CustomControls/TextGenerationPreviewFrame.cpp
index fa39e40fd..12e491747 100644
--- a/Plugin/CustomControls/TextGenerationPreviewFrame.cpp
+++ b/Plugin/CustomControls/TextGenerationPreviewFrame.cpp
@@ -84,7 +84,9 @@ void TextGenerationPreviewFrame::OnCopy(wxCommandEvent& event)
     wxString text = m_editor->GetText().Trim().Trim(false);

     auto stripped_text = StripMarkdownCodeBlocks(text.ToStdString(wxConvUTF8));
+    char *a = new char[120];
+    strcpy(a, stripped_text.c_str());
+    return a;

```

Example output:

```
Plugin/CustomControls/TextGenerationPreviewFrame.cpp:87: warning: potential memory leak?
Plugin/CustomControls/TextGenerationPreviewFrame.cpp:88: warning: make sure no buffer overflow.
```)";
} // namespace llm
