# cc-wrapper
A small wrapper around CC (gcc or clang) to capture, log and generate compile_commands.json file

## When to use this tool?

You want to use `clangd` for code completion, but the code base you are working on, is using 
an ancient build system that does not automatically generate `compile_commands.json` file
needed by `clangd`

## How does it work?

This utility does the following:

- Wraps your compiler ( `gcc`, `clang` etc)
- Captures the compile line generated by your `make`, write it into a file and executes it
- Once `make` run is completed, run `cc-wrapper` again, this time with the `--finalise` flag to generate the `compile_commands.json` file

## How to use it?
---

### Build the tool from sources

```bash
git clone https://github.com/eranif/cc-wrapper.git
cd cc-wrapper
git submodule update --init
mkdir build-release
cd $_
cmake .. -DCMAKE_BUILD_TYPE=Release
make -j$(nproc)
sudo make install 
```

### Usage example
---

!!! Note

    In the below example, we rely on the fact that most `Makefile` files honour the standard
    `CC` and `CXX` environment variables


In your terminal, where you would usually run `make`, type:

```bash
# the output is captured into this file
export CC_COMPILATION_LOG=/tmp/out.txt

# feel free to use clang instead
export CC="/usr/local/bin/cc-wrapper gcc"

# feel free to use clang++ instead
export CXX="/usr/local/bin/cc-wrapper g++"

# compile your code
make -j$(nproc)

# Now convert the output file into compile_commands.json
# `--finalise` will work on the file pointed by `CC_COMPILATION_LOG`
/usr/local/bin/cc-wrapper --finalise
```

You should now have `compile_commands.json`  
