//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : addoptioncheckdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __addoptioncheckdlg__
#define __addoptioncheckdlg__

#include "addoptioncheckdlgbase.h"
#include "compiler.h"

class AddOptionCheckDlg : public AddOptionCheckDialogBase
{
protected:
    Compiler::CmpCmdLineOptions m_cmpOptions;

public:
    AddOptionCheckDlg(wxWindow* parent, const wxString& title, const Compiler::CmpCmdLineOptions& cmpOptions,
                      const wxString& value = wxEmptyString);
    virtual ~AddOptionCheckDlg() = default;

    wxString GetValue() const;
    void SetValue(const wxString& value);

protected:
    void UpdateOptions();
    void UpdateCmdLine();

    // Event generated by wxFormBuilder
    virtual void OnOptionToggled(wxCommandEvent& event);
    virtual void OnOptionsText(wxCommandEvent& event);
};

#endif // __addoptioncheckdlg__
