//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : syntaxhighlightdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __syntaxhighlightdlg__
#define __syntaxhighlightdlg__

/**
@file
Subclass of SyntaxHighlightBaseDlg, which is generated by wxFormBuilder.
*/

#include "lexer_configuration.h"
#include "syntaxhighlightbasedlg.h"
class wxChoice;
class wxNotebook;
class wxTreebook;

/** Implementing SyntaxHighlightBaseDlg */
class SyntaxHighlightDlg : public SyntaxHighlightBaseDlg
{
    bool m_isModified = false;
    bool m_globalThemeChanged = false;
    bool m_promptForRestart = false;
    LexerConf::Ptr_t m_lexer;

protected:
    // toolbar methods
    void OnImportEclipseTheme(wxCommandEvent& event);
    void OnRestoreDefaults(wxCommandEvent& event);
    void OnExportAll(wxCommandEvent& event);
    void OnExportSelective(wxCommandEvent& event);
    void OnImport(wxCommandEvent& event);
    void OnNewTheme(wxCommandEvent& event);

    // other ui events
    void OnStyleFontBold(wxCommandEvent& event) override;
    void OnStyleFontItalic(wxCommandEvent& event) override;
    void OnLineNumberColourChanngedDark(wxColourPickerEvent& event) override;
    void OnLineNumberColourChanngedLight(wxColourPickerEvent& event) override;
    void OnCodeLiteAppearance(wxCommandEvent& event) override;
    void OnGlobalFontSelected(wxFontPickerEvent& event) override;
    void OnGlobalThemeSelected(wxCommandEvent& event) override;
    void OnSelTextFgChanged(wxColourPickerEvent& event) override;
    void OnTextSelFgUI(wxUpdateUIEvent& event) override;
    void OnButtonApplyUI(wxUpdateUIEvent& event) override;
    void OnLexerSelected(wxCommandEvent& event) override;
    void OnColourChanged(wxColourPickerEvent& event) override;
    void OnEditKeyWordsButton0(wxCommandEvent& event) override;
    void OnEditKeyWordsButton1(wxCommandEvent& event) override;
    void OnEditKeyWordsButton2(wxCommandEvent& event) override;
    void OnEditKeyWordsButton3(wxCommandEvent& event) override;
    void OnEditKeyWordsButton4(wxCommandEvent& event) override;
    void OnEolFilled(wxCommandEvent& event) override;
    void OnFontChanged(wxFontPickerEvent& event) override;
    void OnItemSelected(wxCommandEvent& event) override;
    void OnSelTextChanged(wxColourPickerEvent& event) override;
    void OnStyleWithinPreprocessor(wxCommandEvent& event) override;
    void OnStyleWithingPreProcessorUI(wxUpdateUIEvent& event) override;
    void OnText(wxCommandEvent& event) override;

    void DoFontChanged(StyleProperty& sp, const wxFont& font);

    // Handlers for SyntaxHighlightBaseDlg events.
    void OnButtonOK(wxCommandEvent& event) override;
    void OnButtonCancel(wxCommandEvent& event) override;
    void OnButtonApply(wxCommandEvent& event) override;
    void OnThemeChanged(wxCommandEvent& event) override;

    void LoadLexer(const wxString& themeName);
    void SaveChanges();
    void Clear();
    void CreateLexerPage();
    StyleProperty::Vec_t::iterator GetSelectedStyle();
    void EditKeyWords(int set);

    void DoUpdatePreview(const wxColour& lineNumberColour = wxNullColour);
    void DoSetGlobalBgColour(const wxColour& colour);
    void DoExport(const wxArrayString& lexers = wxArrayString());
    void UpdateTextSelectionColours();

public:
    SyntaxHighlightDlg(wxWindow* parent);
    virtual ~SyntaxHighlightDlg();
    bool IsRestartRequired() const;
};

#endif // __syntaxhighlightdlg__
