#ifndef PHPVIEWMODEL_H
#define PHPVIEWMODEL_H

#include "phpworkspaceviewmodel.h" // Base class: PHPWorkspaceViewModel
#include <wx/clntdata.h>
#include <map>

class ItemData : public wxClientData
{
public:
    enum kKIND {
        Kind_Unknown = -1,
        Kind_Workspace,
        Kind_Project,
        Kind_Folder,
        Kind_File
    };

protected:
    kKIND        kind;
    bool         active;     // make sense only if kind == Kind_Project
    wxString     projectName;// make sense only if kind == Kind_Project
    wxString     file;       // make sense only if kind == Kind_File
    wxString     folderPath; // make sense only if kind == Kind_Folder
public:
    ItemData(kKIND k)
        : kind(k)
        , active(false)
    {}

    virtual ~ItemData() = default;

    void SetProjectName(const wxString& projectName) {
        this->projectName = projectName;
    }
    const wxString& GetProjectName() const {
        return projectName;
    }
    void SetActive(bool active) {
        this->active = active;
    }
    void SetFile(const wxString& file) {
        this->file = file;
    }
    void SetFolderPath(const wxString& folderPath) {
        this->folderPath = folderPath;
        if ( this->folderPath.EndsWith("/") ) {
            this->folderPath.RemoveLast();
        }
    }

    void SetKind(kKIND kind) {
        this->kind = kind;
    }
    bool IsActive() const {
        return active;
    }
    const wxString& GetFile() const {
        return file;
    }
    const wxString& GetFolderPath() const {
        return folderPath;
    }

    wxString GetFolderName() const {
        return folderPath.AfterLast('/');
    }

    kKIND GetKind() const {
        return kind;
    }

    bool IsProject() const {
        return kind == Kind_Project;
    }

    bool IsFolder() const {
        return kind == Kind_Folder;
    }

    bool IsFile() const {
        return kind == Kind_File;
    }

    bool IsWorkspace() const {
        return kind == Kind_Workspace;
    }
};

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

/**
 * @class PHPViewModel 
 * @brief inherits from the model generated by wxCrafter for one purpose:
 * keeps a map between the filename and the wxDataViewItem
 */
class PHPViewModel : public PHPWorkspaceViewModel
{
    std::map<wxString, wxDataViewItem> m_all_items;  // Maps between the filename and the dataitemview
public:
    PHPViewModel();
    virtual ~PHPViewModel();
    virtual void DeleteItem(const wxDataViewItem& item);
    virtual void UpdateItem(const wxDataViewItem& item, const wxVector<wxVariant>& data, const wxString &old_filename, const wxString &new_filename);
    
    wxDataViewItem FindByFilename(const wxString& filename) const;
    void Clear();
    
protected:
    virtual wxDataViewItem DoAppendItem(const wxDataViewItem& parent, const wxVector<wxVariant>& data, bool isContainer, wxClientData *clientData = NULL);
    virtual wxDataViewItem DoInsertItem(const wxDataViewItem& insertBeforeMe, const wxVector<wxVariant>& data, bool isContainer, wxClientData *clientData);
};

#endif // PHPVIEWMODEL_H
