//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : new_quick_watch_dlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __new_quick_watch_dlg__
#define __new_quick_watch_dlg__

/**
@file
Subclass of NewQuickWatch, which is generated by wxFormBuilder.
*/

#include "clResizableTooltip.h"
#include "debugger.h"
#include "debuggerobserver.h"

/** Implementing NewQuickWatch */
class DisplayVariableDlg : public clResizableTooltip
{
public:
    IDebugger* m_debugger;
    std::unordered_map<wxString, wxTreeItemId> m_gdbId2Item;
    std::unordered_map<wxString, wxTreeItemId> m_gdbId2ItemLeaf;
    wxString m_mainVariableObject;
    wxString m_variableName;
    wxString m_expression;

protected:
    bool IsFakeItem(const wxTreeItemId& item);
    wxString DoGetItemPath(const wxTreeItemId& item);
    void DoEditItem(const wxTreeItemId& item);

protected:
    void OnItemExpanding(wxTreeEvent& event);
    void OnBtnCancel(wxCommandEvent& e);
    void OnCloseEvent(wxCloseEvent& e);
    void DoAddChildren(wxTreeItemId& item, const VariableObjChildren& children);
    void DoCleanUp();
    void OnItemMenu(wxTreeEvent& event);
    void OnMenuSelection(wxCommandEvent& e);

public:
    /** Constructor */
    DisplayVariableDlg(wxWindow* parent);
    virtual ~DisplayVariableDlg();

    void AddItems(const wxString& varname, const VariableObjChildren& children);
    void UpdateValue(const wxString& varname, const wxString& value);
    void BuildTree(const VariableObjChildren& children, IDebugger* debugger);
    void HideDialog();
    void ShowDialog(bool center);
    void OnCreateVariableObjError(const DebuggerEventData& event);
};

#endif // __new_quick_watch_dlg__
