# CodeLite 18.0.0
---

This page contains the accumulated changes since CodeLite 17.0.0

## Downloads
---

As always, all downloads are available through our [download page][5]

## Changes

---

- Windows Installer updated
- CodeLite now uses 2 top level toolbars:
    - Main toolbar, a native one. Placed on the LEFT by default. This can be changed from the `View` menu
    - Generic one for the plugins (placed on the second row)
- All images are loaded from SVG files
- git plugin: by default, disable the "Commit" info in the navigation bar
- File System Workspace: when launching an executable, use terminal
- Source code formatter: added support for `cmake-format` (doc updated for how to install it)
- Registered `CMake` as a language in CodeLite and associate it with the file type `TypeCMake`
- Windows: MSYS2 is now located using the registry entries first
- Aligned wxCrafter version with CodeLite's one
- Updated CodeLite icon
- Rust compiler: collect crate paths (as reported by cargo during the build) to properly open files with errors (these files paths are reported relative to the crate's Cargo.toml file)
- Language Server: do not fire a code completion request when typing inside a comment or string
- Preferences Dialog: Add missing translations (**rlbxku1r**)
- Update `codelite.pot` (**rlbxku1r**)
- Update Japanese translation (**rlbxku1r**)
- Language Server: optimized the chatter between CodeLite and the LSP:
    - Only ask for semantic tokens when the file is loaded or saved
    - Instead of sending the full file content to server each time a reparse is needed, send the incremental diff (`vector<TextDocumentContentChangeEvent>`)
    - moved CodeLite log file location into a separate folder
    - Fixed `LSP::Range` serialisation to JSON
- Language Server:
    - Removed the "priority field"
    - Allow the user to add custom `initializationOptions` (per the spec)
- Dropped support for `RLS` language server (was deprecated in favour of `rust-analyzer`)
- Language Server:
    - Support `cmake-language-server` auto detection (docs updated)
    - fixed: sometimes, the lsp report back with lower case file paths on Windows.

- source code formatter: when a command is not found, disable the formatter by default
- SSH session: allow the user to change the SSH behaviour by providing the following 3 environment variables:
    - `SSH_OPTIONS_KEY_EXCHANGE`: Set the key exchange method to be used (string, comma-separated list). ex: `ecdh-sha2-nistp256,diffie-hellman-group14-sha1,diffie-hellman-group1-sha1`
    - `SSH_OPTIONS_HOSTKEYS`: Set the preferred server host key types (string, comma-separated list). ex: `ssh-rsa,ssh-dss,ecdh-sha2-nistp256`
    - `SSH_OPTIONS_PUBLICKEY_ACCEPTED_TYPES`: Set the preferred public key algorithms to be used for authentication (string, comma-separated list). ex: `ssh-rsa,rsa-sha2-256,ssh-dss,ecdh-sha2-nistp256`

- C++ version required by CodeLite is now C++17
- CodeLite no longer requires `ssh` terminal to execute remote commands. It now uses `ssh_channel` from `libssh`
- Colours and fonts dialog: `import` toolbar button now allows to select multiple themes to import
- Colours and fonts dialog: newly imported themes will use the global font by default
- Optimized loading of huge JSON files (`~100MB` of json file)
- If the user provided its own mkdir command, do not manipulate it by double quoting it
- Clear modified lines after a file was formatted (otherwise, the entire file is marked as "modified")
- Minor UI change for the word highlight markers
- Added syntax highlight for `TCL` language
- python: support colouring `f-string` (requires one to click on the "Restore" button)
- Deprecate the `Default` build system when creating new project, default to `CodeLite Makefile Generator`
- performance improvement for the ZoomNavigator plugin
- [Implemented: ZoomNavigator zoom factor][14]
- ZoomNavigator: the view now also sync the error / warning markers from the "real" editor
- Changed: remote interactive processes are started using a proxy script
- git: prompt the user in case of failure to commit locally
- Remoty: implemented "replace in files" for remote files using `sed` + `grep`
- Dropped support for codelite-terminal
- highlight word: remove the "HAND" cursor when hovering a highlighted word
- [Experimental: added a built-in terminal. This is not a "full blown" terminal, i.e. you can't use it to edit using `vim`. It does however, support running complex commands and support various operations][17]
- [Language Server: support `workspace/codeActions`. A code action are fixes suggested by the language server. An example for a C++ code action: added missing include header or add missing `;` etc][18]
- Language Server: detect broken paths in configured LSPs and prompt the user with a fix-it button
- CppCheck plugin: use the system installed cppcheck tool instead of installing an old version with CodeLite
- Rust editor: support keyboard for commenting / uncommenting code ( `Ctrl-/` + `Ctrl-Shift-/` )
- Rust editor: `!` is a valid word char
- source code formatter: if no formatters are configured, trigger a scan on startup
- Remote workspace + Remote SFTP view: in case of disconnection due to inactivity, attempt to reconnect
- `Ctrl-TAB` is now working for all notebooks, not only for the main editor book
- Language Server Plugin: clicking on the "Scan" button prompts the user
- Language Server Plugin: the "Scan" button now replaces all entries with what CodeLite found
- [Implemented: Show/Hide Main Toolbar][20]
- Git plugin: the branch name is now shown in the status bar along with the git icon
- [Mark LSP warnings/hint/info with yellow markers and not with the standard error marker][21]
- Added support for Kitty terminal (Linux & macOS)
- git: support using an external diff tool (e.g. winmerge, vimdiff etc)
- Debug Adapter Protocol Client (DAP): fixed issue with breakpoint not set correctly
- Debug Adapter Protocol Client (DAP): fixed bug where init para `cwd` was set to empty value when launching the server
- Debug Adapter Protocol Client (DAP): should now be working with VS Code `cpptools`
- Icons update
- LSP: rename symbol is now supported
- Remoty: reduce a remote workspace load time
- `codelite-cc` is replaced with [cc-wrapper][22]
- Status bar: added 2 buttons on the left side of the status bar for quick showing/hiding the sidebar / bottom bar
- UI redesign: the sidebar is now a new "button like" control. An additional "secondary sidebar" was added. User can move items from the primary sidebar to the secondary
- Status bar: added a "show secondary sidebar" button
- Linux: the IDE is now built using the generic notebook control (changes in wxWidgets no longer allows us to maintain our custom book control)
- Outline view: reduce the font size to be 80% of the default editor font
- Git: support "Redirect" response from server
- Zoom Navigator: the marker is now centred.
- Zoom Navigator: make the marker a bit more visible
- Zoom Navigator: use arrow cursor for the view
- [Hide namespaces in outline view][26]
- VC compiler: improved warning / errors parsing
- Build settings: updated the "Patterns" tab to a more modern look
- Built-in terminal: on Windows, attempt to detect VS installation and offer various shell types: `CMD`, `BASH` or `CMD for Visual Studio NN`
- Built-in terminal: number the tabs
- Use a "hand" cursor when displaying clickable url under a symbol
- Use sensible pane sizes for new installs
- [Allow the user to reposition the sidebar buttons to: top, left or vertical (the default). This can be done from: `settings -> preferences -> tabs -> sidebar buttons position`][29]
- Git console: added context menu to the "log" view (copy/clear)
- Make the various markers (spellchecker, word highlight etc) more visible in dark themes
- Increased the git field width in the status bar
- Performance improvements
- Side bar: respond to DPI change event
- Main editor tab control is now using a subclass of wxAuiNotebook. This allows the user to place tabs side by side by simply dragging them
- `clangd` detector: the `--limit-results` flag now uses the value set by the user in `settings -> code completion -> number of items to display`
- Code completion box: when there is exactly one match in the code completion box, and it matches what the user already written in the editor -> dismiss the box
- Code completion help window: wait 250ms before attempting to display it,
    this reduces the CPU cycles when quickly moving items in the code completion box
- Get back toolbar buttons and add few new buttons (Rozhuk Ivan)
- Code completion box: allow `'` in the cc box (used by various languages like `Rust`)
- Increased  git field width in the status bar
- Switch to more faster regexps for gcc/clang (Rozhuk Ivan)
- Support importing Alacritty themes using the `TOML` format
- Simplified the syntax highlight dialog
- Find in files: hitting ENTER in any field should trigger the search
- Rust plugin: change the default clippy command to: `cargo clippy --color always --all-features --all-targets -- -D warnings`
- LSP plugin: when a broken LSP is found, in addition to the `Attempt to fix` button, add a `Cancel` button
- [Add support for specifying line number when opening a file in single instance mode][36]
- Linux: Register a URL handler for `codelite://` (Anders Jenbo)
- PHP: Add support for Null Safe Operator (Anders Jenbo)
- [PHPParser: Handle PHP Attributes][37] (Anders Jenbo)
- PHP: Add support for enums
- PHP: Upgrade build in standard from PHP 5.6 to 8.3
- Git plugin: Added a "Signed Off" checkbox to the commit dialog
- Built-in terminal: added a dropdown box to allow picking the terminal to open
- Added a ChatAI bot chat. Default shortcut `Ctrl-Shift-H`. The new Chat AI uses a local model files
- macOS, dialogs are placed at the top of the editor - Outline dialog: use standard dialog for displaying the symbols
- Added 3 new themes to the default themes
- Improved VS-code theme importing
- Syntax highlight: honour the line number colours set in the configuration
- SSH plugin: added an option to use custom SSH keys
- Gopls LSP: enable semantic tokens colouring by default
- Changed default settings for maximum performance
- Added LSP detector for `golang`
- Removed unused menu context entry ("Detach editor")
- Java syntax highlight: colour local variables Fixed: https://github.com/eranif/codelite/issues/3410 - CodeLite hangs while searching for compilers
- Source code formatter: apply the environment variables before executing the foramtting tool
- Source code formatter: added an option to add custom formatters Source code formatter: added an option to delete a formatter
- LSP: python detector (pylsp): improved search method on macOS Java: updated the keyword list + added support for variable colouring LSP: added support for jdtls language server (Java)
- File System workspace: fixed drawing glitch
- Updated the folders icons
- updated Markdown icons
- Added an icon to Java + Go file types
- Removed font size multiplier [#3531](https://github.com/eranif/codelite/issues/3531)
- MSW: avoid restarting CodeLite automatically - let the user exit and start CodeLite
- update cmake build command line for wxWidgets
- Git plugin: files shown in the git log + git commit dialogs are now sorted
- Windows: position dialogs similar to macOS
- All: allow user to force a light theme Linux: use default notebook, similar to macOS & Windows
- Sidebar: use 24 bmp buttons on Linux and 32 on macOS / Windows
- Simplified the DAP Debugger plugin UI interface
- Toolchain warning [#3519](https://github.com/eranif/codelite/issues/3519)
- * Smaller sidebar icons [#3516](https://github.com/eranif/codelite/issues/3516)
- Fixed: since LLVM-18, lldb-vscode was renamed into `lldb-dap` - fixed locator to support both names
- When adding page to the sidebar, do not make it active https://github.com/eranif/codelite/issues/3231
- Minor UI fix to the "Welcome Page"
- Shortcuts do not work when editor has no source code files open. [#3231](Fixed: https://github.com/eranif/codelite/issues/3231)
- Remove non-existing path in TailUI.wxcp: ../bitmaps/16-find.png and ../bitmaps/16-find@2x.png [#3501](https://github.com/eranif/codelite/issues/3501)
- Fixed [Garbled / misplaced auto-completion text while typing](https://github.com/eranif/codelite/issues/3490)
- Fixed: git plugin: right clicking on a deleted file in the git view and selecting "Revert" is not working
- Fixed a lag when updating the line / column fields of the status bar
- Fixed: pattern matching not working for hidden files
- Fixed: no syntax highlighting for `.tsx` files
- Welcome page: colour the workspace different properties (type, host)
- Markdown parser: fixed parsing of unordered lists starting with '*'
- Truncate code completion tooltip text to a managable size (1K)
- Git plugin: make the "Add a Signed-off-by trailer" option persistent entry
- Added a "Signed Off" checkbox to the commit dialog


## Bug fixes

---

- [Subclass of wxSpinCtrl crashes wxCrafter][1]
- Fixed: find in files: exclude patterns are not always working
- wxCrafter: removed the `wxTRANSPARENT_WINDOW` style (it was changed to `0` in wxWidgets, that caused it to looks like it is always enabled in the UI)
- Language Server: in case the lsp command does not exist, disable it (better than the alternative: crashing CodeLite)
- [latest master build fails with assertion dialog during startup][2]
- [Support horizontal scrolling in the various tree/list controls in CodeLite][3]
- [always use `mkdir -p` (which should be available on platforms)][4]
- Fixed: windows GDI objects leak
- Before opening SSH session, apply the environment variables
- more assertion fixes with debug builds of wxWidgets
- [Outline view does not work][6]
- [cancel calltip + cc box when the editor is losing the focus][7]
- [support importing alacritty colour themes into CodeLite][8]
- [Run (CTRL+F5 shortcut) won't work after Build (F7 shortcut) in version 17.1.0][9]
- [Remember last scroll position in code tabs][10]
- ['Trim only modified lines' checkbox UI problem][11]
- [restore the save/save-all toolbar buttons][12]
- fixed: Alacritty terminal not working on macOS
- fixed: When repeatedly launching processes, the environment variables might grow until a point where `execvp()` returns with `E2BIG` and eventually crashing CodeLite
- [Trim Trailing Spaces (Edit menu) does not work][13]
- fixed: git console "Add file" & "Reset file" are now enabled based on the list state
- Fixed: git plugin should now be disabled when there is no active git repository
- Fixed: git console buttons: "Add file" & "Reset file" not working
- Fixed: remote language servers started by CodeLite, now honour the `env` field of the `codelite-remote.json` file
- fixed: file system workspace: properly restore the session after load
- fixed: [CodeLite loses focus when build completes][15]
- fixed: [CodeLite crash if home directory contains non ASCII chars][16]
- [simplify the auto-indent when ENTER is hit after "public" keyword][19]
- When closing the last tab in the editor, clear the window frame title
- [Fixed: Removing file(s) in Workspace View also removes deselected files, wrong dialog, bad spelling...][23]
- [fixed: Bug/Regression: Left-click on ruler to place a break-point shows right-click popup menu instead][24]
- [Fixed: RXVT terminal: support multiple executable options (`rxvt-unicode`, `rxvt` and `urxvt`)][25]
- Fixed: Zoom navigator: saving a file loses the focus
- [Fixed: ctags include dirs][27]
- [Fixed: function description box is larger than the screen][28]
- Various fixes to make CodeLite working better under `GDK_BACKEND=wayland`
- [Bug: Moving cursor up/down through code with up/down buttons very slow, causes large CPU usage][30]
- [fixed: Bug: Filesystem Workspace does not include file extensions with upper case][31]
- fixed: MSW: File System Workspace: use ignore-case for file comparison when attempting to locate file in the tree view
- Rust (remoty) - do not attempt to guess the current working directory, just use the workspace path as the root
- [CppCheck crash][32]
- [On Windows, use native toolbar for the side bar control][33]
- Fixed: editor flickers after foramtter execution
- SpellChecker: instead of parsing the line based on position, use Line + Col approach - this way, if we have offset error, it will only affect the current line
  dnd the offset error will not get carried over to the next line.
- SpellChecker: use `UTF8Lengh()` method to calculate real length of tokens, this should fix problems when using non ASCII chars in the document
  and the spelling error marker does not correctly mark the word
- [Language Server Diagnostics are not shown anymore since 17.9.0][34]
- Fixed: spellchecker highlights sometimes are not aligned with the editor text
- Fixed: there is a noticable lag when typing while the function argument tooltip is shown
- Fixed: when the function arguments tip window shows, skip the first argument if it is "self" (e.g. for class method in `Python` or `Rust`)
- Fixed: when LSP tries to place many markers ("diagnostics") on the editor, it causes an excessive reads from the disk which can cause a noticable lag
- Editor navigation bar: remove the "bookmark" button (it causes too much extra work for CodeLite with no real benefit)
- Fixed: Rust: the configuration option "Hitting ENTER in a C++ comment adds '//'" does not work Removed un-needed log line entry
- Navigation control (Ctrl-Tab popup window) is now centered on CodeLite, regardless of its parent book
- [Fixed: closing a modified tab on Linux / macOS causes to lose modified changes][35]
- Fixed: some LSPs return completions that start with a ".", remove it before inserting it
- Fixed: Crashes and lockups when parsing PHP projects
- Fixed: Markdown rendering: parsing of unordered lists starting with '*'
- Fixed: possible crash when CodeLite is started and one of the LSPs has an empty command
- Fixed: possible crash when the VIM plugin is enabled while closing a workspace
- Fixed: https://github.com/eranif/codelite/issues/3451
- Fixed: honour the "Show close button on tabs" settings on restart
- Fixed: margin hover tips + clicks are not working
- Fixed: mouse cursor flicker when moving it over the left side margin of an editor
- Fixed macOS: resizing windows is broken (sash dragging is not always working)

[1]: https://github.com/eranif/codelite/issues/3054
[2]: https://github.com/eranif/codelite/issues/3131
[3]: https://github.com/eranif/codelite/issues/3103
[4]: https://github.com/eranif/codelite/issues/3134
[5]: https://downloads.codelite.org
[6]: https://github.com/eranif/codelite/issues/3153
[7]: https://github.com/eranif/codelite/issues/3155
[8]: https://github.com/alacritty/alacritty-theme
[9]: https://github.com/eranif/codelite/issues/3152
[10]: https://github.com/eranif/codelite/issues/3165
[11]: https://github.com/eranif/codelite/issues/1171
[12]: https://github.com/eranif/codelite/issues/3151
[13]: https://github.com/eranif/codelite/issues/3188
[14]: https://github.com/eranif/codelite/issues/3159
[15]: https://github.com/eranif/codelite/issues/3216
[16]: https://github.com/eranif/codelite/issues/3219
[17]: https://github.com/eranif/codelite/issues/3202
[18]: https://github.com/eranif/codelite/issues/3095
[19]: https://github.com/eranif/codelite/issues/3235
[20]: https://github.com/eranif/codelite/issues/3156
[21]: https://github.com/eranif/codelite/issues/3267
[22]: https://github.com/eranif/cc-wrapper
[23]: https://github.com/eranif/codelite/issues/3233
[24]: https://github.com/eranif/codelite/issues/3247
[25]: https://github.com/eranif/codelite/issues/3273
[26]: https://github.com/eranif/codelite/issues/3271
[27]: https://github.com/eranif/codelite/issues/3280
[28]: https://github.com/eranif/codelite/issues/3282
[29]: https://github.com/eranif/codelite/issues/3287
[30]: https://github.com/eranif/codelite/issues/3210
[31]: https://github.com/eranif/codelite/issues/3311
[32]: https://github.com/eranif/codelite/issues/3301
[33]: https://github.com/eranif/codelite/issues/3323
[34]: https://github.com/eranif/codelite/issues/3333
[35]: https://github.com/eranif/codelite/issues/3367
[36]: https://github.com/eranif/codelite/issues/3384
[37]: https://github.com/eranif/codelite/issues/3392
