**Release Notes – v19.0.0**
*CodeLite – LSP, AI/LLM, UI & platform upgrades*

---

## 📋 Summary of Contributions

| Contributor | Commits |
|------------|--------:|
| **Eran Ifrah** | **232** |
| **Joris Dauphin** | 56 |
| **Uffe Jakobsen** | 10 |
| **Jarod 42** | 9 |
| **dghart** | 5 |
| **Anders Jenbo** | 1 |
| **Guillermo Bernaldo de Quiros Maraver** | 1 |
| **bztd** | 1 |
| **tuwulin365** | 1 |

*All contributions are listed in descending order of commit count.*

---

## 🚀 Major Improvements

### 1. AI / LLM – core platform upgrades
* **Support for multiple LLM providers** CodeLite supports multiple LLM providers, such as "Ollama" & "Anthropic".
* **Unified LLM manager** – new `LLMManager` component with model‑listing, enable/disable helpers, interrupt support, and history handling.
* **Endpoint wizard & multi‑model UI** – a wizard for selecting the active provider, a drop‑down that persists the chosen model, and a “Clear history / Restart client” action.
* **Extended AI‑powered features** – code‑review, release‑note generation, doc‑string creation, function documentation, and automatic commit‑message suggestions.
* **Server‑side improvements** – timeout configuration (connect/read/write), automatic configuration reload on file‑save, and support for Ollama, Anthropic (Claude), DeepSeek and other providers.
* **RAII helpers** – `FunctionsDisabler`, `EnableAllFunctions()`, `EnableFunctionByName()` to safely toggle LLM features.

### 2. Language Server Protocol (LSP) enhancements
* **Unified manager** – `LSP::Manager` replaces the old `LSPManager`; all language‑server capabilities (completion, hover, go‑to‑definition/declaration, workspace symbols, semantic tokens, call‑tips, etc.) now go through a single entry point.
* **Accelerated command handling** – Find Symbol, Rename Symbol, Find References are grouped in a global accelerator group; per‑editor bindings removed.
* **Selection‑aware navigation** – “Go to Definition” now prefers the start of the current selection.
* **Header lookup & workspace symbols** – `LSP::Manager::FindHeaderFile` and `WorkspaceSymbols` provide direct server queries, replacing the legacy event‑based mechanisms.
* **Semantic‑token driven theming** – editor colours now update automatically from LSP semantic tokens.

### 3. Editor & UI modernisation
* **Unified Outline View** – Quick Outline replaced by a single Outline View with its own LSP document‑symbol event (`wxEVT_LSP_DOCUMENT_SYMBOLS_OUTLINE_VIEW`).
* **Navigation bar enrichment** – now shows classes, structs, enums, and interfaces as well as functions.
* **Improved toolbars** – all toolbars migrated to `wxAuiToolBar`; icons, accelerators and sash widths (250 px) refreshed.
* **IndicatorPanel** – reusable background‑task status widget used by both Git and ChatAI panels.
* **Prompt editor & preview** – `PromptEditorDlg` and `TextGenerationPreviewFrame` replace modal dialogs; markdown‑styled prompts, JSON parsing, and scroll‑resilience added.
* **Platform‑native notebooks** – Git “Changes” view now uses the native notebook widget on each OS (wxAuiNotebook, wxNativeBook, clGenericNotebook).

### 4. Git console and file‑tool upgrades
* **AI‑driven Git tools** – code‑review integration, release‑note generation button in the Git toolbar, and batch processing of commit logs.
* **Enhanced log handling** – `FetchLogBetweenCommits` splits logs into chunks, filters noise and returns a typed error object.

### 5. Configuration, build & platform support
* **Centralised config APIs** – `CreateOrOpenConfig()`, full validation, version checks and automatic backups for LLM settings.
* **CMake modernisation** – switched to `add_compile_definitions`, removed obsolete flags, and added hidden build‑directory layout (`.build‑debug`, `.build‑release`).
* **Cross‑platform fixes** – added OpenBSD support, updated third‑party submodules (assistant, ctagsd, dtl, libssh, yaml‑cpp), migrated many utilities to `std::unique_ptr`/`std::optional`, and replaced old typedefs with `using`.
* **Documentation overhaul** – README, download pages and ChatAI docs reorganised; badges, quick‑link tables and animated GIFs added.

### 6. Refactors & clean‑ups
* Consolidated XML utilities under `XmlUtils`.
* Moved string utilities to `StringUtils`.
* Replaced dead event bindings (`wxEVT_CC_*`, `wxEVT_WXC_PROPETY_CHANGED`, etc.).
* Applied modern C++ keywords (`override`, `explicit`, `nullptr`, `[[maybe_unused]]`).

---

## 🐞 Bug Fixes (consolidated)

* **Typo & spelling corrections** – hundreds of identifiers, comments and UI strings fixed (e.g., “behaviour → behavior”, “Parentesis → Parenthesis”).
* **Comment‑detection logic** – `IsPositionInComment` added; prevents completions and call‑tips inside comments.
* **Status‑message timeout** – reduced from 3 s to 1 s for doc‑string generation and LSP symbol requests.
* **Duplicate/obsolete event removal** – cleaned up `wxEVT_CC_*`, `wxEVT_WXC_PROPETY_CHANGED`, dead Outline‑view events, and dead LSP bindings.
* **Crash & stability fixes** – guard against null pointers in Git dialogs, Text Generation windows, LSP request handling, and remote workspace searches; fixed Linux‑specific crashes with wx3.2.
* **Header‑lookup and workspace‑symbol bugs** – resolved missing symbols, corrected file‑path handling (UTF‑8 conversions, proper quoting of paths with spaces).
* **Build‑system issues** – fixed missing includes (`<memory>`, `<mutex>`, `<atomic>`), corrected `std::numeric_limits<size_t>::max()` usage, and resolved GCC 15 and MSVC C++20 compilation errors.
* **Git‑related fixes** – improved log chunking, corrected toolbar bitmap handling, fixed rebase tool crashes, and restored missing “Add unstaged file” action.
* **AI UI glitches** – toolbar sizer flags, background‑task icon glitches, model‑selection dropdown resizing, and proper handling of empty model lists.
* **Remote & SSH improvements** – macro `WorkspaceRealPath` always resolved, safe deletion of custom SSH keys, and correct handling of special regex characters in remote searches.
* **Miscellaneous** – updated README badges, refreshed French localisation, removed unused headers, and applied consistent code‑formatting throughout the code base.

---

## 🙏 Acknowledgements

A huge thank‑you to **Eran Ifrah**, **Joris Dauphin**, **Uffe Jakobsen**, **Jarod 42**, and all other contributors listed above. Your relentless effort makes each release stronger and more feature‑rich.

*For a full diff, see the repository history.*