//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : code_completion_manager.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef CODECOMPLETIONMANAGER_H
#define CODECOMPLETIONMANAGER_H

#include "cl_command_event.h"
#include "cl_editor.h"
#include "clangd/CompileCommandsGenerator.h"

#include <thread>
#include <wx/event.h>
#include <wx/filename.h>
#include <wx/string.h>

class CodeCompletionManager : public wxEvtHandler
{
protected:
    size_t m_options = 0;
    bool m_buildInProgress = false;
    CompileCommandsGenerator::Ptr_t m_compileCommandsGenerator;

protected:
    size_t CreateBlockCommentKeywordsList(wxCodeCompletionBoxEntry::Vec_t& entries) const;

protected:
    // Event handlers
    void OnBuildEnded(clBuildEvent& e);
    void OnFilesAdded(clCommandEvent& e);
    void OnWorkspaceLoaded(clWorkspaceEvent& e);
    void OnWorkspaceClosed(clWorkspaceEvent& event);

    void OnBuildStarted(clBuildEvent& e);
    void OnAppActivated(wxActivateEvent& e);
    void OnCompileCommandsFileGenerated(clCommandEvent& event);
    void OnFileSaved(clCommandEvent& event);
    void OnFileLoaded(clCommandEvent& event);
    void OnWorkspaceConfig(wxCommandEvent& event);
    void OnEnvironmentVariablesModified(clCommandEvent& event);
    void OnBlockCommentCodeComplete(clCodeCompletionEvent& event);
    void OnBlockCommentWordComplete(clCodeCompletionEvent& event);

public:
    CodeCompletionManager();
    virtual ~CodeCompletionManager();

    void SetOptions(size_t options) { this->m_options = options; }
    size_t GetOptions() const { return m_options; }

    static CodeCompletionManager& Get();
    static void Release();
};

#endif // CODECOMPLETIONMANAGER_H
