#ifndef SCANNER_HPP
#define SCANNER_HPP

#include "Cxx/CxxTokenizer.h"
#include "macros.h"

#include <unordered_map>
#include <wx/arrstr.h>
#include <wx/filename.h>
#include <wx/string.h>

class Scanner
{
    wxStringSet_t m_missing_includes;
    std::unordered_map<wxString, std::set<wxString> > m_matches;

private:
    bool IsFileExists(const wxString& current_dir, const wxString& name, const wxArrayString& search_path,
                      std::set<wxString>& fixed_path);
    void ParseUsingNamespace(CxxTokenizer& tokenizer, wxStringSet_t* using_ns_set);

    wxString fix_include_line(const wxString& include_line);

public:
    Scanner();
    ~Scanner();

    void scan(const wxFileName& current_file, const wxArrayString& search_path, wxStringSet_t* includes_set,
              wxStringSet_t* using_ns_set);
    void scan_buffer(const wxFileName& current_file, const wxString& content, const wxArrayString& search_path,
                     wxStringSet_t* includes_set, wxStringSet_t* using_ns_set);
};

#endif // SCANNER_HPP
